import React from "react";
import { Link } from "react-router-dom";
import { usePuzzleStore } from "../store/puzzleStore";

export default function Navbar() {
  const { levels, levelIndex, streak, correctCount } = usePuzzleStore();
  const current = levels[levelIndex] || null;

  return (
    <header className="w-full py-4 px-6 flex items-center justify-between glass">
      <div className="flex items-center gap-3">
        <div className="text-2xl font-bold">🧩 PuzzlePort</div>
        <div className="text-sm text-white/70">
          {current ? `Level ${current.level} — ${current.name}` : "Loading..."}
        </div>
      </div>

      <div className="flex items-center gap-4">
        <div className="text-sm text-white/80">
          🔥 <span className="font-semibold">{streak}</span>
        </div>
        <div className="text-sm text-white/80">
          Score: <span className="font-semibold">{correctCount}</span>
        </div>
        <Link to="/leaderboard" className="px-3 py-1 bg-white/6 rounded">
          Leaderboard
        </Link>
      </div>
    </header>
  );
}
